IF EXISTS
(
    SELECT *
    FROM SYS.VIEWS
    WHERE OBJECT_ID = OBJECT_ID(N'[DBO].V_PDV_VD_IT_COMPARACAO_PDV_VD')
)
    DROP VIEW [DBO].[V_PDV_VD_IT_COMPARACAO_PDV_VD];
GO
--SELECT * FROM V_PDV_VD_IT_COMPARACAO_PDV_VD WHERE CD_EMP =1 AND CD_FILIAL = 23 AND DT_VD ='2019-05-13'
CREATE VIEW V_PDV_VD_IT_COMPARACAO_PDV_VD
AS
     --Pegando cabecalho sem itens
     SELECT PDV_VD.CD_EMP, 
            PDV_VD.CD_VD, 
            PDV_VD.CD_FILIAL, 
            PDV_VD.DT_VD, 
            PDV_VD.NR_ECF, 
            CD_CX, 
            SUM(VLR_LIQ_VD) AS VLR_LIQ_VD, 
            0 AS TOT_IT, 
            ISNULL(PDV_VD.CD_USU_CANCEL, 0) AS CD_USU_CANCEL, 
            NR_ORC
     FROM PDV_VD
          LEFT OUTER JOIN PDV_VD_IT IT ON PDV_VD.CD_EMP = IT.CD_EMP
                                          AND PDV_VD.CD_FILIAL = IT.CD_FILIAL
                                          AND PDV_VD.CD_VD = IT.CD_VD
                                          AND PDV_VD.DT_VD = IT.DT_VD
     WHERE PDV_VD.ST_VD = 0
           AND IT.CD_VD IS NULL
     GROUP BY CD_CX, 
              PDV_VD.CD_VD, 
              PDV_VD.NR_ECF, 
              PDV_VD.CD_EMP, 
              PDV_VD.CD_FILIAL, 
              PDV_VD.DT_VD, 
              PDV_VD.CD_USU_CANCEL, 
              PDV_VD.NR_ORC
     UNION ALL
     --Pegando diferenca entre cabecalho e cupom
     SELECT PDV_VD.CD_EMP, 
            PDV_VD.CD_VD, 
            PDV_VD.CD_FILIAL, 
            PDV_VD.DT_VD, 
            PDV_VD.NR_ECF, 
            CD_CX, 
            VLR_LIQ_VD AS VLR_LIQ_VD, 
            ISNULL(VLR_PROD, 0) AS TOT_IT, 
            ISNULL(CD_USU_CANCEL, 0) AS CD_USU_CANCEL, 
            NR_ORC
     FROM PDV_VD
          INNER JOIN
     (
         SELECT CD_EMP, 
                CD_FILIAL, 
                CD_VD, 
                DT_VD, 
                SUM(TOT_IT-VLR_DESC_TOT_RAT) AS VLR_PROD
         FROM PDV_VD_IT
         WHERE ST_IT = 1
         GROUP BY CD_EMP, 
                  CD_FILIAL, 
                  CD_VD, 
                  DT_VD
     ) IT ON PDV_VD.CD_EMP = IT.CD_EMP
             AND PDV_VD.CD_FILIAL = IT.CD_FILIAL
             AND PDV_VD.CD_VD = IT.CD_VD
             AND PDV_VD.DT_VD = IT.DT_VD
     WHERE PDV_VD.ST_VD = 0
           AND PDV_VD.VLR_LIQ_VD <> IT.VLR_PROD;